/***************************************************************************
 *
 * Copyright (c) 2013 Codethink Limited
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ****************************************************************************/

#include <unistd.h>

#include <csignal>
#include <cstdlib>
#include <iostream>
#include <sstream>
#include <unistd.h>

#include "InputDeviceConfiguration.h"
#include "WLContext.h"
#include "WLEGLSurface.h"
#include "SubdivisionRenderer.h"

using namespace std;
using namespace LayerManagerCalibration;

int gRunLoop = 1;
int gNeedRedraw = 0;

static void sigFunc(int)
{
    cout << "Caught signal" << endl;
    gRunLoop = 0;
}

int main(int argc, char **argv)
{
    if (argc < 6)
    {
        cerr << endl;
        cerr << "Usage: " << argv[0] << " CONFIG_FILE_PATH DISP_WIDTH DISP_HEIGHT TOUCH_WIDTH TOUCH_HEIGHT" << endl;
        cerr << endl;
        exit(1);
    }

    InputDeviceConfiguration config;
    if (!config.parseFile(argv[1]))
    {
        cerr << "Failed to parse device configuration file '" << argv[1]
             << "'" << endl;
        exit(1);
    }

    stringstream ssDW(argv[2]);
    stringstream ssDH(argv[3]);
    stringstream ssTW(argv[4]);
    stringstream ssTH(argv[5]);
    uint dispWidth, dispHeight, touchWidth, touchHeight;

    if ((ssDW >> dispWidth).fail())
    {
        cerr << "Can't convert value to display width '" << argv[2] << "'" << endl;
        exit(1);
    }

    if ((ssDH >> dispHeight).fail())
    {
        cerr << "Can't convert value to display height '" << argv[3] << "'" << endl;
        exit(1);
    }

    if ((ssTW >> touchWidth).fail())
    {
        cerr << "Can't convert value to touch width '" << argv[4] << "'" << endl;
        exit(1);
    }
    if ((ssTH >> touchHeight).fail())
    {
        cerr << "Can't convert value to touch height '" << argv[5] << "'" << endl;
        exit(1);
    }

    cout << "Read device configuration from: " << argv[1] << endl;
    cout << "Read display width: " << dispWidth << endl;
    cout << "Read display height: " << dispHeight << endl;
    cout << "Read touch width: " << touchWidth << endl;
    cout << "Read touch height: " << touchHeight << endl;

    WLContext* wlContext;
    WLEGLSurface *eglSurface;
    t_ilm_layer layerId = 4000;
    t_ilm_surface surfaceId = 5500;

    signal(SIGINT, sigFunc);

    ilm_init();

    wlContext = new WLContext();
    wlContext->InitWLContext(&PointerListener, &KeyboardListener, &TouchListener);

    eglSurface = new WLEGLSurface(wlContext);
    eglSurface->CreateSurface(dispWidth, dispHeight);
    eglSurface->CreateIlmSurface(&layerId, &surfaceId, dispWidth, dispHeight);

    if (!InitRenderer(&config, dispWidth, dispHeight, touchWidth, touchHeight))
    {
        cerr << "Failed to initialize renderer" << endl;
        exit(1);
    }

    drawSubdivisions(eglSurface, &config);

    // wait for termination
    while (gRunLoop)
    {
        wl_display_flush(wlContext->GetWLDisplay());
        wl_display_dispatch(wlContext->GetWLDisplay());
        if (gNeedRedraw && gRunLoop)
        {
            drawSubdivisions(eglSurface, &config);
            gNeedRedraw = 0;
        }
        usleep(50);
    }

    cout << "Terminating example" << endl;

    TerminateRenderer();
    ilm_layerRemoveSurface(layerId, surfaceId);
    ilm_UpdateInputEventAcceptanceOn(surfaceId,
                                     ILM_INPUT_DEVICE_TOUCH,
                                     ILM_FALSE);
    ilm_commitChanges();
    eglSurface->DestroyIlmSurface();
    ilm_commitChanges();

    ilm_destroy();

    delete eglSurface; //Segfaults here, for some reason
    delete wlContext;

    return 0;
}
